% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 31Mar2012
% TITLE: Quantifiable value of information in direct marketing
% Related web page:
% http://finaquant.com/quantifiable-value-of-information-in-direct-marketing/796

disp('********************************************************************');
disp('Case 1: Goal is reaching every aquarium-keeper household at all costs');
disp('********************************************************************');
promo_cost = 5;
population = 100000;
percentage = 0:100;

InfoValue_AquariumKeeper_List = population * (1 - percentage/100) * 5;
disp('Plot information value of the list of aquarium-keepers');
plot(percentage, InfoValue_AquariumKeeper_List)
xlabel('% aquarium-keeper households')
ylabel('value in $')
title('Value of complete aquarium-keepers list')
figure

InfoValue_AquariumLess_List = percentage/100 * population * 5;
disp('Plot information value of the list of aquarium-less households');
plot(percentage, InfoValue_AquariumLess_List)
xlabel('% addresses in list w.r.t. population')
ylabel('value in $')
title('Value of the list of aquarium-less households')
figure

disp('********************************************************************');
disp('Case 2: Goal is maximizing net earnings from the campaign');
disp('********************************************************************');
% assumed conditional probability of response
x = 1:200;
CondResponseProb = response_probability(x);
plot(x,CondResponseProb);
xlabel('hist. sales in $')
ylabel('response probability')
title('Conditional probability of response')
figure

% generate historical data for evaluation campaign
MinAmount = 0;
MaxAmount = 200;

disp('Generate TRAINING data');
N = 700;
x1 = purchase_distribution(N, MinAmount, MaxAmount);
x2 = x1 .^ 2;
y = response(response_probability(x1));

% construct matrices
X_train = [ones(1,N); x1; x2];
Y_train = y';

disp('Generate TEST data');
M = 300;
x1 = purchase_distribution(M, MinAmount, MaxAmount);
x2 = x1 .^ 2;
y = response(response_probability(x1));

% construct matrices
X_test = [ones(1,M); x1; x2];
Y_test = y';

disp('Find optimal coefficient vector B with training data');
Bopt = inv(X_train * X_train') * X_train * Y_train
% get data from file
% load matlab_Bopt

disp('Calculate estimated response probabilities');
Ye_train = X_train' * Bopt;
Ye_test = X_test' * Bopt;

disp('Calculate training and test error');
E_train = Y_train - Ye_train;
SSE_train = E_train' * E_train;
MSE_train = SSE_train / N

E_test = Y_test - Ye_test;
SSE_test = E_test' * E_test;
MSE_test = SSE_test / M

disp('Show curve fitting (approximation) for test data');
[x1, ind] = sort(X_test(2,:)); 

disp('LR probability estimator is ready');
x1 = 1:200;
x2 = x1 .^ 2;
X = [ones(1,200); x1; x2];
Ye = X' * Bopt;
plot(x1, CondResponseProb,'b', x1, Ye','r');
xlabel('hist. sales in $')
ylabel('response probability')
title('Observed (blue) vs estimated (red line) probability')
figure

promo_earning = 50;
promo_cost = 5;

disp('Generate data for main campaign');
K = 10000;
x1 = purchase_distribution(K, MinAmount, MaxAmount);
x2 = x1 .^ 2;
y = response(response_probability(x1));
Y = y';
% construct matrices
X = [ones(1,K); x1; x2];

% get data from file
% load matlab_X
% load matlab_Y
% x1 = X(2,:);

TotalResponse = sum(Y) 

disp('Calculate estimated response probabilities');
% Ye = response_probability(x1)';   % real (assumed) probability
Ye = X' * Bopt;       % LR estimation

disp('Calculate estimation error');
E = Y - Ye;
SSE = E' * E;
MSE = SSE / K

disp('Sort estimated probabilities (customer scores) in descending order');
[Ye_sorted, ind] = sort(Ye,'descend');
x1_sorted = x1(ind);
Y_sorted = Y(ind);
v = 1:K;

plot(x1_sorted, Ye_sorted);
xlabel('ordered sales')
ylabel('response probability')
title('Estimated probabilities vs ordered sales)')
figure

% plot(v, Ye_sorted *200,'b', v, x1_sorted,'r');
% xlabel('#customer')
% ylabel('sales / probability')
% title('Estimated probabilities (blue) vs sales (red)')
% figure

disp('Find customers with expected earnings larger than 0');
selected_customers = (Ye_sorted > promo_cost/promo_earning);
selected_customers_ind = find(selected_customers == 1);

disp('Lift and profit curves, score-selected customers');
% cumulated sum of selected customers that responded to promo mails
cumsum_responding_selected_customers = cumsum(Y_sorted .* selected_customers);
% profit curve of selected customers
profit_selected_customers = 50 * cumsum_responding_selected_customers - 5 * cumsum(selected_customers);

response_selected_customers = sum(Y_sorted .* selected_customers)
totalmails_selected_customers = sum(selected_customers)
hitrate_selected_customers = response_selected_customers / totalmails_selected_customers
NetEarnings_selected_customers = 50 * response_selected_customers - 5 * totalmails_selected_customers

% v = 1:K;
% plot(v,cumsum_responding_selected_customers,'b',v,profit_selected_customers,'r')
% xlabel('ordered customers')
% ylabel('#responses/profit curve')
% title('#responses (blue) & profit curve (red) of selected customers')
% figure

disp('Lift and profit curves, unselected customers');
% cumulated sum of customers that responded to promo mails
cumsum_responding_all_customers = cumsum(Y);
% profit curve of customers
profit_all_customers = 50 * cumsum_responding_all_customers - 5 * (1:K)';

response_all_customers = sum(Y_sorted)
totalmails_all_customers = K
hitrate_all_customers = response_all_customers / totalmails_all_customers
NetEarnings_all_customers = 50 * response_all_customers - 5 * totalmails_all_customers
 
% v = 1:K;
% plot(v,cumsum_responding_customers,'b', v,profit_customers,'r')
% xlabel('customers')
% ylabel('#responses/profit curve')
% title('#responses & profit curve of customers')

disp('Lift curves (#responses): Selected vs all customers');
v = 1:K;
plot(v,cumsum_responding_selected_customers,'b', v,cumsum_responding_all_customers,'r')
xlabel('customers')
ylabel('#responses/profit curve')
title('#responses of selected (blue) vs all (red) customers')
figure

disp('Profit curves: Selected vs all customers');
v = 1:K;
plot(v,profit_selected_customers,'b', v,profit_all_customers,'r')
xlabel('customers')
ylabel('net earnings')
title('Net earnings from selected (blue) vs all (red) customers')



